﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace Spektro_analyzer
{
	public partial class Messline : Form
	{
		Mainform MF;
		public Mainform Mainform {
		    get { return MF; }
		    set { MF = value; }
		}
        int startmouse_y = 0;
		int startmouse_x = 0;
		
		#region form
		public Messline()
		{
			InitializeComponent();
		}
		void Label_closeClick(object sender, EventArgs e)
		{
			MF.tbtn_main_setup.ForeColor = Color.Black;
			MF.set_messline = false;
			this.Hide();
		}
		void Label_closeMouseEnter(object sender, EventArgs e)
		{
			label_close.BackColor = Color.Red;
		}
		void Label_closeMouseLeave(object sender, EventArgs e)
		{
			label_close.BackColor = Color.Gray;
		}
		
		void Label_messlineMouseDown(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Left) {
				label_messline.BackColor = Color.Lime;
				startmouse_x = Cursor.Position.X - this.Left - 3;
				startmouse_y = Cursor.Position.Y - this.Top - 3;
			}
		}
		void Label_messlineMouseMove(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Left) 
			{
				this.Top += e.Y - startmouse_y;
				this.Left += e.X - startmouse_x;
			}
		}
		void Label_messlineMouseUp(object sender, MouseEventArgs e)
		{
			label_messline.BackColor = Color.LimeGreen;
		}
		void Label_messlineMouseEnter(object sender, EventArgs e)
		{
			label_messline.BackColor = Color.LimeGreen;
		}
		void Label_messlineMouseLeave(object sender, EventArgs e)
		{
			label_messline.BackColor = Color.Gray;
		}
		#endregion
		
		void Btn_gra_resetClick(object sender, EventArgs e)
		{
			MF.tbtn_gra_resetzoom.PerformClick();
		}
		
		void Check_graph_withIRCheckedChanged(object sender, EventArgs e)
		{
			MF.IRfarbverlauf = check_graph_withIR.Checked;
		}
	}
}
